@extends('layouts.master')
@section('content')

    <!-- Header Section -->
    @include('website.profile.header', ['header_name' =>   __('lang.my_account') ])

    <section class="account-detsils-section ">
        <div class="container-fluid p-100 ">
            <div class="row justify-content-center">
                <div class="row">
                    @include('website.profile.slider', ['page' => "Account details"])

                    <div class="col-9 form-Adetails">
                        <form action="{{ route('profile.update.password') }}" method="POST">
                            @csrf

                            <!-- First Name -->
                            <div class="form-group-Adetails mb-4">
                                <label for="oldPassowrd">{{ __('lang.old_passowrd') }} *</label>
                                <input type="password" name="old_passowrd" class="form-control custom-input-accountdet" id="oldPassowrd" placeholder="{{ __('lang.old_passowrd') }}" value="" required>
                                @error('old_passowrd')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Last Name -->
                            <div class="form-group-Adetails mb-4">
                                <label for="newPassword">{{ __('lang.new_password') }} *</label>
                                <input type="password" name="new_password" class="form-control custom-input-accountdet" id="newPassword" placeholder="{{ __('lang.new_password') }}" value="" required>
                                @error('new_password')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Display Name -->
                            <div class="form-group-Adetails mb-4">
                                <label for="repeatNewPassword">{{ __('lang.repeat_new_password') }} *</label>
                                <input type="password" name="new_password_confirmation" class="form-control custom-input-accountdet" id="repeatNewPassword" placeholder="{{ __('lang.repeat_new_password') }}" value="">
                                <small class="display-text-form">{{ __('lang.repeat_new_password') }}</small>
                                @error('repeat_new_password')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Buttons -->
                            <div class="form-group d-flex account-details-buttons">
                                <button type="submit" class="btn submit-btn-Adetails">{{ __('lang.submit') }}</button>
                                <button type="button" class="btn change-password-btn-Adetails">{{ __('lang.want_account_details') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
    </section>

@endsection

