
@extends('layouts.master')
@section('page-name', __('lang.Books'))

@section('content')
    <!-- Header Section -->
    @include('website.productComponent.index.header-section',[
    'header_breadcrumb' => __("lang.book_header_breadcrumb"),
    'header_subtitle' => getColumn($coverDescription, 'content'),
    'header_title' => __("lang.Books"),
])
    <!-- Cards and Catecory Section-->
    <section class="buy-now-section ">
        <div class="container-fluid p-100">
            <div class="row">
                @include('website.productComponent.index.category-box',[
                        'categories' => $categories,
                        'category_filter_route' => "books.index"
                 ])



                <!-- Right Section for Courses -->
                @include('website.productComponent.index.products-section', [
                     'products' => $books,
                     'type' => "books",
                     'image_collection' => app()->getLocale() == 'ar' ? \App\Enums\Media\MediaCollection::BOOK_IMAGE_ARABIC->value : \App\Enums\Media\MediaCollection::BOOK_IMAGE_ENGLISH->value,
                     'product_route_name' =>'books.show',
                    ])
            </div>
        </div>
        </div>

    </section>

@endsection
