@php use App\Enums\About\AboutUsTypes;use App\Enums\Media\MediaCollection; @endphp
@extends('layouts.master')
@section('page-name', __('lang.About Us'))
@section('content')

    <!-- Header Section -->
    @include('website.productComponent.index.header-section',[
    'header_breadcrumb' => __("lang.about_us"),
    'header_subtitle' => getColumn($coverDescription, 'content'),
    'header_title' => __("lang.about_us"),

])

    @foreach($about_us_sections as $about_us_section)
        @if($about_us_section->type == AboutUsTypes::SLOGAN->value)
            <section class="container-fluid p-100">
                <div class="quote-container">
                    <div class="quote-icon left">
                        <img src="{{ asset('website/assets/images/quote left.png') }}" alt="Opening Quote Icon">
                    </div>
                    <div class="quote-content">
                        <p class="quote-text">{!! getColumn($about_us_section, 'description') !!}</p>
                        <p class="quote-author">{{ getColumn($about_us_section, 'title') }}</p>
                    </div>
                    <div class="quote-icon right">
                        <img src="{{ asset('website/assets/images/oui_quote.png') }}" alt="Closing Quote Icon">
                    </div>
                </div>
            </section>
        @endif
        @if($about_us_section->type == AboutUsTypes::VISION->value)
            <!-- Our Vision -->
            <section class="our-vision">
                <div class="container-fluid p-100">
                    <div class="row">
                        <div class="col-md-6 image-ourvision">
                            <img
                                src="{{ $about_us_section->getFirstMediaUrl(MediaCollection::ABOUT_US->value) }}"
                                class="img-fluid vision-image" alt="Vision">
                        </div>
                        <div class="col-md-6 content-ourvision">
                            <h2 data-aos="fade-up" data-aos-duration="1000"
                                data-aos-offset="10">{{ getColumn($about_us_section, 'title') }}</h2>
                            <p data-aos="fade-up" data-aos-duration="1000"
                               data-aos-offset="10">{!! getColumn($about_us_section, 'description') !!}</p>
                        </div>
                    </div>
                </div>
            </section>
        @endif
        @if($about_us_section->type == AboutUsTypes::MISSION->value)
            <!-- Our Mission -->
            <section class="our-mission">
                <div class="container-fluid p-100">
                    <div class="row">
                        <div class="col-md-6 content-ourvision">
                            <h2 data-aos="fade-up" data-aos-duration="1000"
                                data-aos-offset="10">{{ getColumn($about_us_section, 'title') }}</h2>
                            <p data-aos="fade-up" data-aos-duration="1000"
                               data-aos-offset="10">{!! getColumn($about_us_section, 'description') !!}</p>

                        </div>
                        <div class="col-md-6 image-ourvision">
                            <img src="{{ $about_us_section->getFirstMediaUrl(MediaCollection::ABOUT_US->value) }}"
                                 class="img-fluid vision-image" alt="Mission Image" data-aos="fade-up"
                                 data-aos-duration="1000" data-aos-offset="10">
                        </div>
                    </div>
            </section>
        @endif
        @if($about_us_section->type == AboutUsTypes::OUR_MESSAGE->value)
            <!-- Our Values -->
            <section class="our-values">
                <div class="container-fluid p-100">
                    <div class="row">
                        <div class="col-md-6 image-ourvision">
                            <img src="{{ $about_us_section->getFirstMediaUrl(MediaCollection::ABOUT_US->value) }}"
                                 class="img-fluid vision-image" alt="Values Image" data-aos="fade-up"
                                 data-aos-duration="1000" data-aos-offset="10">
                        </div>
                        <div class="col-md-6 content-ourvision">
                            <h2 data-aos="fade-up" data-aos-duration="1000"
                                data-aos-offset="10">{{ getColumn($about_us_section, 'title') }}</h2>
                            <p data-aos="fade-up" data-aos-duration="1000"
                               data-aos-offset="10">{!! getColumn($about_us_section, 'description') !!}</p>

                        </div>
                    </div>
            </section>
        @endif
        @if($about_us_section->type == AboutUsTypes::YOU_TUBE->value)

            <!-- Video Section -->
            <section class="container-fluid p-100">
                <div class="video-section" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                    <div class="video-container">
                        <div class="video-overlay-about"
                             style="background-image: url('{{ $about_us_section->getFirstMediaUrl('about_us')}}'); background-size: cover"
                             data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                            <div class="play-button" onclick="openVideoModal('')">
                                <img src="{{ asset('website/assets/images/vedio-icon.webp') }}" alt="Play Button">
                            </div>
                        </div>
                    </div>
                    <div class="description-vedio">
                        <p>{{ __('lang.video_description_about') }}</p>
                        <div class="d-flex justify-content-center mt-5">
                            <a href="{{$about_us_section->youtube_channel_url}}"
                               class="join-youtube-channel">{{ __('lang.join_youtube_channel') }}</a>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Video Modal -->
            <div id="videoModal" class="modal">
                <div class="modal-content">
                    <span class="close" onclick="closeVideoModal()">&times;</span>
                    <iframe id="videoFrame" src="" frameborder="0" allowfullscreen hidden></iframe>

                    {!! $about_us_section->youtube_video_url !!}
                </div>
            </div>
        @endif
    @endforeach

@endsection
