@section('payment')
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="csrf-token" content="{{ csrf_token() }}"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Card View Payment</title>

    <style></style>
</head>

<body>

<br>
{{--<script src="https://portal.myfatoorah.com/cardview/v1/session.js"></script>--}}
<div style="width:700px">
    <div id="card-element"></div>
</div>




<script>
    var config = {
        countryCode: '{{$session['CountryCode'] }}', // Here, add your Country Code.
        sessionId: '{{$session['SessionId']}}', // Here you add the "SessionId" you receive from InitiateSession Endpoint.
        cardViewId: "card-element",
        // The following style is optional.
        style: {
            direction: "ltr",
            cardHeight: 200,
            input: {
                color: "black",
                fontSize: "13px",
                fontFamily: "sans-serif",
                inputHeight: "32px",
                inputMargin: "0px",
                borderColor: "c7c7c7",
                borderWidth: "1px",
                borderRadius: "8px",
                boxShadow: "",
                placeHolder: {
                    holderName: "Name On Card",
                    cardNumber: "Number",
                    expiryDate: "MM / YY",
                    securityCode: "CVV",
                }
            },
            label: {
                display: false,
                color: "black",
                fontSize: "13px",
                fontWeight: "normal",
                fontFamily: "sans-serif",
                text: {
                    holderName: "Card Holder Name",
                    cardNumber: "Card Number",
                    expiryDate: "Expiry Date",
                    securityCode: "Security Code",
                },
            },
            error: {
                borderColor: "red",
                borderRadius: "8px",
                boxShadow: "0px",
            },
        },
    };
    myFatoorah.init(config);

    function submit() {
        myFatoorah.submit()
            // On success
            .then(function (response) {
                    // Here you need to pass session id to you backend here


                    var url = '{{route('website.payment.execute')}}'

                    var data = {
                        "session_id": response.SessionId
                    }
                    $.ajax({
                            type: 'POST',
                            url: url,
                            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                            data: JSON.stringify(data),
                            contentType: 'application/json; charset=utf-8',
                            cache: false,
                            processData: false,
                            beforeSend: function () {
                                // $('.invalid-feedback').text('');
                                //
                                // btn.attr("data-kt-indicator", "on").attr('disabled', true);
                            },

                            success: function (response) {

                                if (response.PaymentURL) {

                                    setTimeout(function () {
                                        window.location.replace(response.PaymentURL+'&');
                                    }, 1000)

                                } else {

                                    setTimeout(function () {
                                        location.reload();
                                    }, 1000)

                                }
                            },

                            error: function (response) {
                                alert('not success');

                            }

                        }
                    )
                }
            )
    }


</script>

</body>

</html>
@stop
