<?php

namespace Database\Seeders;

use App\Models\Course;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use App\Models\Order;
class WordpressCoursesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
       
        try {
            DB::beginTransaction();
            
        //      $courses = [
        //     [
        //         'post_title' => 'المراهقين: التعامل معهم، مشاكلهم وحلها',
        //         'ID' => 2252
        //     ],
        //     [
        //         'post_title' => 'تدريب التحكم بالعصبية للأب والأم',
        //         'ID' => 2259
        //     ],
        //     [
        //         'post_title' => 'فهم المرحلتين العمريتين للطفل  0-5 سنوات ومرحلة 6-11 سنة',
        //         'ID' => 2263
        //     ],
        //     [
        //         'post_title' => 'خطتي لمساعدة للأطفال المتأخرين " بالكلام"',
        //         'ID' => 5786
        //     ],
        //     [
        //         'post_title' => '30Days summer challenge  تحدي تلاتين يوم',
        //         'ID' => 6552
        //     ],
        //     [
        //         'post_title' => 'تدريب التعامل مع الطفل العنيد / العصبي',
        //         'ID' => 7156
        //     ],
        //     [
        //         'post_title' => 'تدريب التعامل مع المراهقين',
        //         'ID' => 8946
        //     ]
        // ];

        // foreach ($courses as $course) {
        //     $storeCourses = Course::create([
        //         'name_ar' => $course['post_title'],
        //         'name_en' => $course['post_title'],
        //         'slug' =>  Str::slug($course['post_title'], '-'),


        //         'short_description_ar' => $course['post_title'],
        //         'short_description_en' => $course['post_title'],
        //         'long_description_ar' => $course['post_title'],
        //         'long_description_en' => $course['post_title'],
        //         'price' => rand(10,200),
        //         'objectives_ar' =>$course['post_title'],
        //         'objectives_en' => $course['post_title'],
        //         'course_highlights_ar' => $course['post_title'],
        //         'course_highlights_en' => $course['post_title'],
        //         'time' => rand(10,100),
        //         'age_from' => rand(2,5),
        //         'age_to' => rand(5,13),
        //         'earn_ar' => $course['post_title'],
        //         'earn_en' => $course['post_title'],
        //         'prerequisites_ar' => $course['post_title'],
        //         'prerequisites_en' => $course['post_title'],
        //         'instructor_name_ar' => "ahmed Sbeata",
        //         'instructor_name_en' => "ahmed Sbeata",
        //         'instructor_position_ar' => "ahmed Sbeata",
        //         'instructor_position_en' => "ahmed Sbeata",
        //         'instructor_short_description_ar' =>"ahmed Sbeata",
        //         'instructor_short_description_en' => "ahmed Sbeata",
        //         'instructor_long_description_ar' => "ahmed Sbeata",
        //         'instructor_long_description_en' => "ahmed Sbeata",
        //         'is_new' => true,
        //         'is_featured' => true,
        //         'status' => true,
        //         'category_id' => "9cf8cf01-d4a6-48d5-8f97-f531d6f85b87",
        //     ]);
        // }
        
        //insert wordpress users
            // $response = Http::get("https://kydzoo.intcore.dev/api/wordpress");

            // foreach ($response->json() as $user){
            //     User::query()->updateOrCreate(['email'=>$user['user_email']],[

            //         'first_name' =>$user['user_nicename'],
            //         'last_name' =>$user['user_nicename'],
            //         'display_name' =>$user['display_name'],
            //         'email' =>$user['user_email'],
            //         'password' => $user['user_pass'],
            //     ]);
            // };
            
            // insert wordpress orders
              $orders = file_get_contents(public_path('orders.json'));

            foreach (json_decode($orders) as $order){

                $course = Course::where('name_ar', $order->post_title)->first();

                $customer = User::where('email', $order->user_email)->first();
                if(!$course){
                    \Log::alert('course '. $order->post_title. ' not found');
                }
                 if(!$customer){
                    \Log::alert('customer '. $order->user_email. ' not found');
                }
                Order::create(
                    [
                        "amount" => $order->total_sales,
                        "productable_type" => "App\Models\Course",
                        "productable_id" => $course->id,
                        "user_id" => $customer->id,
                        "created_at" => $order->date_created,
                        "status" => 2,

                    ]
                );
            };
            
            DB::commit();
        }catch (\Exception $exception){
            DB::rollBack();
             \Log::alert('exception ', ['exception' => $exception]);
        }



    }
}
