<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('books', function (Blueprint $table) {
            $table->uuid('id')->primary()->default(DB::raw('(UUID())'));
            $table->string('name_ar');
            $table->string('name_en');
            $table->string('slug');

            $table->float('price');
            $table->text('description_ar');
            $table->text('description_en');

            $table->text('section_one_title_en');
            $table->text('section_one_title_ar');
            $table->text('section_one_description_en');
            $table->text('section_one_description_ar');


            $table->text('section_two_title_en');
            $table->text('section_two_title_ar');
            $table->text('section_two_description_en');
            $table->text('section_two_description_ar');

            $table->text('section_three_title_en');
            $table->text('section_three_title_ar');
            $table->text('section_three_description_en');
            $table->text('section_three_description_ar');

            $table->boolean('status')->default(true);
            $table->boolean('is_featured')->default(false);
            $table->foreignUuid('category_id')->references('id')->on('categories');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('books');
    }
};
