<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->uuid('id')->primary()->default(DB::raw('(UUID())'));
            $table->string('title_ar');
            $table->string('title_en');
            $table->string('slug');

            $table->string('author_ar');
            $table->string('author_en');
            $table->text('content_ar');
            $table->text('content_en');
            $table->boolean('status')->default(true);
            $table->boolean('is_featured')->default(false);
            $table->foreignUuid('category_id')->references('id')->on('categories');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};
