<?php

namespace App\Services\Website\Profile;

use App\DTOs\AbstractDTO;
use App\Models\BaseModel;
use App\Models\User;
use App\Repositories\Interfaces\UserRepositoryInterface;
use Exception;
use Illuminate\Contracts\Auth\Authenticatable;

class UpdateUserProfileService
{
    private AbstractDTO $dto;
    private User $user;

    /**
     * @param UserRepositoryInterface $userRepository
     */
    public function __construct(
        private readonly UserRepositoryInterface $userRepository
    )
    {
    }

    /**
     * @param AbstractDTO $dto
     * @return self
     */
    final public function setDto(AbstractDTO $dto): self
    {
        $this->dto = $dto;
        return $this;
    }

    /**
     * @throws Exception
     */
    final public function execute(): BaseModel|User|null
    {
        return $this->userRepository->update($this->user->id, $this->dto->toArray());

    }

    /**
     * @param User|Authenticatable $user
     * @return self
     */
    final public function setUser(User|Authenticatable $user): self
    {
        $this->user = $user;
        return $this;
    }

}
