<?php

namespace App\Services\Website\Courses;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\CourseRepositoryInterface;
use App\Services\BaseService;

class GetCoursesService extends BaseService
{
    private AbstractDTO $dto;

    public function __construct(
        private readonly CourseRepositoryInterface $courseRepository
    )
    {
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->courseRepository->get($this->dto);
    }
}
