<?php

namespace App\Services\Website\Contacts;

use App\Repositories\Interfaces\ContactInfoRepositoryInterface;
use Illuminate\Database\Eloquent\Model;

class ContactInfoService
{
    /**
     * @param ContactInfoRepositoryInterface $contactInfoRepo
     */
    public function __construct(private readonly ContactInfoRepositoryInterface $contactInfoRepo)
    {
    }

    /**
     * @return Model|null
     */
    public function getContactInfo(): ?Model
    {
        return $this->contactInfoRepo->first();
    }
}
