<?php

namespace App\Services\Website\Category;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\CategoryRepositoryInterface;
use App\Services\BaseService;

class GetCategoriesService extends BaseService
{
    private AbstractDTO $dto;
    private string $type;

    public function __construct(
        private readonly CategoryRepositoryInterface $categoryRepository
    )
    {
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->categoryRepository->get($this->dto, $this->type);
    }

    /**
     * @param string $type
     * @return GetCategoriesService
     */
    public function setType(string $type): self
    {
        $this->type = $type;
        return $this;
    }

}
