<?php

namespace App\Services\Website\Brand;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\BrandRepositoryInterface;
use App\Services\BaseService;

class GetBrandsService extends BaseService
{
    private AbstractDTO $dto;

    public function __construct(
        private readonly BrandRepositoryInterface $brandRepository
    )
    {
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->brandRepository->get($this->dto);
    }
}
