<?php

namespace App\Services\Website\Book;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\BookRepositoryInterface;
use App\Services\BaseService;

class GetInterestedBooksService extends BaseService
{
    private AbstractDTO $dto;
    private string $category_id;

    public function __construct(
        private readonly BookRepositoryInterface $bookRepository
    )
    {
    }

    /**
     * @param string $category_id
     * @return self
     */
    public function setCategoryId(string $category_id): self
    {
        $this->category_id = $category_id;
        return $this;
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->bookRepository->getInterestedBooks(dto: $this->dto, categoryId: $this->category_id);
    }
}
