<?php

namespace App\Services\Website\Book;

use App\Repositories\Interfaces\BookRepositoryInterface;
use App\Services\BaseService;

class GetBookBySlugService extends BaseService
{
    private string $slug;

    public function __construct(
        private readonly BookRepositoryInterface $bookRepository
    )
    {
    }

    /**
     * @param string $slug
     */
    public function setSlug(string $slug): self
    {
        $this->slug = $slug;
        return $this;
    }


    public function execute()
    {
        return $this->bookRepository->getBySlug($this->slug);
    }
}
