<?php

namespace App\Services\Website\Blog;

use App\DTOs\AbstractDTO;
use App\Repositories\Interfaces\BlogRepositoryInterface;
use App\Services\BaseService;

class GetBlogService extends BaseService
{
    private AbstractDTO $dto;

    public function __construct(
        private readonly BlogRepositoryInterface $blogRepository
    )
    {
    }

    public function setDto(AbstractDTO $DTO): static
    {
        $this->dto = $DTO;
        return $this;
    }

    function execute()
    {
        return $this->blogRepository->get($this->dto);
    }
}
