<?php

namespace App\Services\Website\Blog;

use App\Repositories\Interfaces\BlogRepositoryInterface;
use App\Services\BaseService;

class GetBlogBySlugService extends BaseService
{
    private string $slug;

    public function __construct(
        private readonly BlogRepositoryInterface $blogRepository
    )
    {
    }

    /**
     * @param string $slug
     * @return GetBlogBySlugService
     */
    public function setSlug(string $slug): self
    {
        $this->slug = $slug;
        return $this;
    }


    public function execute()
    {
        return $this->blogRepository->getBySlug($this->slug);
    }
}
