<?php

namespace App\Services;


use App\Models\BaseModel;
use Illuminate\Http\UploadedFile;

abstract class BaseService
{
    /**
     * @var array
     */
    protected array $data;

    /**
     * @var array|UploadedFile|null|string
     */
    protected null|UploadedFile|array|string $image = null;

    /**
     * @var BaseModel
     */
    protected BaseModel $resource;


    /**
     * @param array $data
     * @return $this
     */
    public function setData(array $data): self
    {
        $this->data = $data;
        return $this;
    }

    /**
     * @param string|null $column
     * @return array|string|null
     */
    public function getData(string $column = null): array|string|null
    {
        return $column ? ($this->data[$column] ?? null) : $this->data;
    }

    /**
     * @param BaseModel $resource
     * @return $this
     */
    public function setResource(BaseModel $resource): self
    {
        $this->resource = $resource;
        return $this;
    }

    /**
     * Set the image object.
     *
     * @param UploadedFile|string|array|null $image
     * @return $this
     */
    public function setImage(null|UploadedFile|string|array $image): self
    {
        $this->image = $image;
        return $this;
    }

    /**
     * Get the image object.
     *
     * @return null|UploadedFile|string|array
     */
    public function getImage(): array|UploadedFile|string|null
    {
        return $this->image;
    }


    /**
     * Main function in each service
     * @return BaseModel|bool|void
     */
    abstract function execute();

}
