<?php

namespace App\Repositories\Interfaces;


use App\DTOs\AbstractDTO;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Pagination\LengthAwarePaginator;

interface BlogRepositoryInterface
{
    public function get(AbstractDTO $dto):  Collection|LengthAwarePaginator;

    public function getBySlug(string $slug): ?Model;
    public function getInterestedBlogs(AbstractDTO $dto, string $categoryId): Collection;

}

