<?php

namespace App\Repositories;

use App\DTOs\AbstractDTO;
use App\Models\BaseModel;
use App\Models\Contact;
use App\Repositories\Interfaces\ContactUsRepositoryInterface;
use Illuminate\Database\Eloquent\Model;

class ContactUsRepository extends Repository implements ContactUsRepositoryInterface
{
    public function __construct(Contact $model)
    {
        $this->setModel($model);
    }

    /**
     * @param AbstractDTO $dto
     * @return BaseModel|null
     */
    public function store(AbstractDTO $dto): ?BaseModel
    {
        return $this->getModel()->create($dto->toArray());
    }
}
