<?php

namespace App\Repositories;


use App\DTOs\AbstractDTO;
use App\Models\AboutUs;
use App\Repositories\Interfaces\AboutUsRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;

class AboutUsRepository extends Repository implements AboutUsRepositoryInterface
{
    public function __construct(AboutUs $model)
    {
        $this->setModel($model);
    }

    public function get(AbstractDTO $dto): ?Collection
    {
        return $this->getModel()->active()->get();
    }
}

