<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Course extends BaseModel implements HasMedia
{
    use HasFactory;
    use HasUuids;
    use InteractsWithMedia;

    protected $table = 'courses';
    protected $fillable = [
        'name_ar',
        'name_en',
        'slug',

        'short_description_ar',
        'short_description_en',
        'long_description_ar',
        'long_description_en',
        'price',
        'sale_price',
        'first_highlight_ar',
        'first_highlight_en',
        'objectives_ar',
        'objectives_en',
        'second_highlight_ar',
        'second_highlight_en',
        'course_highlights_ar',
        'course_highlights_en',
        'time',
        'age_from',
        'age_to',
        'earn_ar',
        'earn_en',
        'prerequisites_ar',
        'prerequisites_en',
        'instructor_name_ar',
        'instructor_name_en',
        'instructor_position_ar',
        'instructor_position_en',
        'instructor_short_description_ar',
        'instructor_short_description_en',
        'instructor_long_description_ar',
        'instructor_long_description_en',
        'is_new',
        'is_featured',
        'status',
        'category_id',
    ];

    protected $casts = [
        'is_new' => 'boolean',
        'is_featured' => 'boolean',
        'status' => 'boolean',
        'price' => 'float',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }


    /**
     * Apply all relevant Sizes filters
     *
     * @param Builder $query
     * @return Builder
     */
    public function scopeIsFeatured(Builder $query): Builder
    {
        return $query->where('is_featured', true);
    }

    /**
     * Apply all relevant Sizes filters
     *
     * @param Builder $query
     * @return Builder
     */
    public function scopeIsNotFeatured(Builder $query): Builder
    {
        return $query->where('is_featured', false);
    }

    public function videos(): HasMany
    {
        return $this->hasMany(Video::class);
    }

    public function order(): MorphOne
    {
        return $this->morphOne(Order::class, 'productable');
    }
}
