<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

/**
 * Class BaseModel
 * @mixin Builder
 * @package App\Foundation\Models
 */
class BaseModel extends Model
{
    use HasUuids;

    /**
     * Apply all relevant Sizes filters
     *
     * @param Builder $query
     * @return Builder
     */
    public function scopeActive(Builder $query): Builder
    {
        return $query->where('status', true);
    }

}
