<?php

namespace App\Http\Requests\Website;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class UpdateAccountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'first_name'    => 'required|string|max:255',
            'last_name'     => 'required|string|max:255',
            'display_name'  => 'required|string|max:255',
            'email'         => 'required|email|max:255|unique:users,email,' . Auth::id(),
        ];
    }

    /**
     * Get the validation error messages with translations.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'first_name.required'   => trans('validation.required', ['attribute' => trans('lang.first_name')]),
            'last_name.required'    => trans('validation.required', ['attribute' => trans('lang.last_name')]),
            'display_name.required' => trans('validation.required', ['attribute' => trans('lang.display_name')]),
            'email.required'        => trans('validation.required', ['attribute' => trans('lang.email_address')]),
            'email.email'           => trans('validation.email', ['attribute' => trans('lang.email_address')]),
            'email.unique'          => trans('validation.unique', ['attribute' => trans('lang.email_address')]),
        ];
    }
}
