<?php

namespace App\Http\Controllers\Website;

use App\DTOs\Api\Page\ShowPageDTO;
use App\Http\Controllers\Controller;
use App\Services\Website\Page\GetPageService;
use Illuminate\Http\Request;
use Illuminate\View\View;

class PageController extends Controller
{
    /**
     * AuthController construct
     */
    public function __construct(
        private readonly GetPageService $pageService,
    ) {
    }

    /**
     * @param $slug
     * @return View
     * @throws \Exception
     */
    public function show($slug): View
    {

        $dto = new ShowPageDTO(['page' => $slug]);
        $pageService = $this->pageService->setDto($dto);
        $pageService->execute();

        return view('website.page', [
            'content' => $pageService->getContent(),
        ]);

    }
}
