<?php

namespace App\Http\Controllers\Website;

use App\DTOs\Api\Announcement\GetAnnouncementDto;
use App\DTOs\Api\Blog\GetBlogDto;
use App\DTOs\Api\Book\GetBookDto;
use App\DTOs\Api\Brand\GetBrandDto;
use App\DTOs\Api\Course\GetCourseDto;
use App\DTOs\Api\Event\GetEventDto;
use App\DTOs\Api\Testimonial\GetTestimonialDto;
use App\Enums\Home\HomeTypes;
use App\Http\Controllers\Controller;
use App\Models\Home;
use App\Services\Website\Announcement\GetAnnouncementService;
use App\Services\Website\Blog\GetBlogService;
use App\Services\Website\Book\GetIsFeaturedBooksService;
use App\Services\Website\Brand\GetBrandsService;
use App\Services\Website\Courses\GetFeaturedCoursesService;
use App\Services\Website\Event\GetIsFeaturedEventService;
use App\Services\Website\Testimonial\GetTestimonialService;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    const LIMIT = 20;
    const BLOG_LIMIT = 2;

    public function __construct(
        private readonly GetFeaturedCoursesService $getFeaturedCoursesService,
        private readonly GetAnnouncementService    $getAnnouncementService,
        private readonly GetBrandsService          $getBrandsService,
        private readonly GetIsFeaturedBooksService $getIsFeaturedBooksService,
        private readonly GetIsFeaturedEventService $getIsFeaturedEvent,
        private readonly GetTestimonialService     $getTestimonialService,
        private readonly GetBlogService            $getBlogService,
    )
    {
    }

    public function index(Request $request)
    {
        $request->merge(['limit' => self::LIMIT]);

        $getCourseDto = new GetCourseDto($request->only('limit'));
        $isFeaturedCourses = $this->getFeaturedCoursesService->setDto($getCourseDto)->execute();


        $getAnnouncementDto = new GetAnnouncementDto([]);
        $announcement = $this->getAnnouncementService->setDto($getAnnouncementDto)->execute();

        $getBrandDto = new GetBrandDto($request->only('limit'));
        $brands = $this->getBrandsService->setDto($getBrandDto)->execute();

        $getBookDto = new GetBookDto($request->only('limit'));
        $isFeaturedBooks = $this->getIsFeaturedBooksService->setDto($getBookDto)->execute();

        $getEventDto = new GetEventDto($request->only('limit'));
        $isFeaturedEvents = $this->getIsFeaturedEvent->setDto($getEventDto)->execute();

        $getTestimonialDto = new GetTestimonialDto($request->only('limit'));
        $testimonials = $this->getTestimonialService->setDto($getTestimonialDto)->execute();


        $getBlogDto = new GetBlogDto(['limit' => self::BLOG_LIMIT]);
        $blogs = $this->getBlogService->setDto($getBlogDto)->execute();

        $slogan = Home::where('type', HomeTypes::SLOGAN->value)->first();
        $youtube = Home::where('type', HomeTypes::YOU_TUBE->value)->first();
        $about = Home::where('type', HomeTypes::ABOUT_KYDZZO->value)->first();
        $doctor = Home::where('type', HomeTypes::DOCTOR_SECTION->value)->first();
        $cover = Home::where('type', HomeTypes::COVER->value)->first();

        return view('website.home', [
            'isFeaturedCourses' => $isFeaturedCourses,
            'announcement' => $announcement,
            'brands' => $brands,
            'isFeaturedBooks' => $isFeaturedBooks,
            'isFeaturedEvents' => $isFeaturedEvents,
            'testimonials' => $testimonials,
            'blogs' => $blogs,
            'slogan' => $slogan,
            'youtube' => $youtube,
            'about' => $about,
            'doctor' => $doctor,
            "cover" => $cover
        ]);
    }
}
