<?php

namespace App\Http\Controllers\Website;

use App\DTOs\Api\Book\GetBookDto;
use App\DTOs\Api\Category\GetCategoryDto;
use App\Enums\Category\CategoryTypes;
use App\Http\Controllers\Controller;
use App\Models\Page;
use App\Services\Website\Book\GetBookBySlugService;
use App\Services\Website\Book\GetBooksService;
use App\Services\Website\Book\GetInterestedBooksService;
use App\Services\Website\Category\GetCategoriesService;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;

class BookController extends Controller
{
    public function __construct(
        private readonly GetBooksService           $getBooksService,
        private readonly GetBookBySlugService      $getBookBySlugService,
        private readonly GetInterestedBooksService $getInterestedBooksService,
        private readonly GetCategoriesService      $getCategoriesService,
    )
    {
    }

    public function index(Request $request): View|\Illuminate\Foundation\Application|Factory|Application
    {
        $request->merge(['paginated' => true]);

        $dto = new GetBookDto($request->only('paginated', 'categories'));

        $books = $this->getBooksService->setDto($dto)->execute();

        $categoryDto = new GetCategoryDto([]);

        $categories = $this->getCategoriesService->setDto($categoryDto)->setType(CategoryTypes::BOOK->value)->execute();
        $coverDescription = Page::query()->where('slug', \App\Enums\Page\Page::BOOKS_COVER_DESCRIPTION->value)->first();

        return view('website.books', [
            "books" => $books,
            "categories" => $categories,
            "coverDescription" => $coverDescription,
        ]);
    }

    public function show(Request $request, string $slug): View|\Illuminate\Foundation\Application|Factory|Application
    {
        $dto = new GetBookDto($request->all());
        $book = $this->getBookBySlugService->setSlug($slug)->execute();

        $interested_books = $this->getInterestedBooksService->setDto($dto)->setCategoryId($book->category_id)->execute();

        return view('website.books-show', [
            "book" => $book,
            "interested_books" => $interested_books,
        ]);
    }
}
