<?php

namespace App\Http\Controllers\Website;

use App\DTOs\Api\Blog\GetBlogDto;
use App\Http\Controllers\Controller;
use App\Models\Page;
use App\Services\Website\Blog\GetBlogBySlugService;
use App\Services\Website\Blog\GetBlogService;
use App\Services\Website\Blog\GetInterestedBlogsService;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use App\DTOs\Api\Category\GetCategoryDto;
use App\Services\Website\Category\GetCategoriesService;
use App\Enums\Category\CategoryTypes;

class BlogController extends Controller
{
    public function __construct(
        private readonly GetBlogService            $getBlogService,
        private readonly GetBlogBySlugService      $getBlogBySlugService,
        private readonly GetInterestedBlogsService $getInterestedBlogsService,
         private readonly GetCategoriesService      $getCategoriesService,

    )
    {
    }

    public function index(Request $request): View
    {
        $request->merge(['paginated' => true]);

        $dto = new GetBlogDto($request->only('paginated', 'search', 'categories'));

        $blogs = $this->getBlogService->setDto($dto)->execute();
        $coverDescription = Page::query()->where('slug', \App\Enums\Page\Page::BLOGS_COVER_DESCRIPTION->value)->first();
         $categoryDto = new GetCategoryDto([]);

        $categories = $this->getCategoriesService->setDto($categoryDto)->setType(CategoryTypes::BLOG->value)->execute();

        return view('website.blogs', [
            "blogs" => $blogs,
            "coverDescription" => $coverDescription,
            "categories" => $categories,

        ]);
    }

    public function show(Request $request, string $slug): View
    {
        $dto = new GetBlogDto($request->all());

        $blog = $this->getBlogBySlugService->setSlug($slug)->execute();

        $interested_blogs = $this->getInterestedBlogsService->setDto($dto)->setCategoryId($blog->category_id)->execute();

        return view('website.blog-show', [
            "blog" => $blog,
            "interested_blogs" => $interested_blogs,
        ]);
    }
}
