<?php

namespace App\Filament\Resources\UserResource\Pages;

use App\Enums\Order\OrderStatus;
use App\Enums\Product\ProductType;
use App\Filament\Resources\UserResource;
use App\Models\Order;
use App\Models\User;
use Filament\Resources\Pages\Page;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class ShowUser extends Page implements HasTable
{
    use InteractsWithTable;

    protected static string $resource = UserResource::class;
    protected static string $view = 'filament.resources.user-resource.pages.show-user';

    public User $user;

    public function mount($record): void
    {
        // Retrieve the full user model using the provided record (user ID)
        $this->user = User::findOrFail($record);
    }

    public function table(Table $table): Table
    {
        return $table
            ->query($this->getTableQuery())
            ->columns([
                TextColumn::make('status')->formatStateUsing(function (TextColumn $column): ?string {
                    return OrderStatus::getStatus($column->getRecord()->status);
                })->label('Status'),

                TextColumn::make('amount')->label('Amount'),

                TextColumn::make('productable_id')
                    ->formatStateUsing(function (TextColumn $column): ?string {

                        return $column->getRecord()->productable?->name_en;
                    })
                    ->label('Product Name'),

                TextColumn::make('productable_type')
                    ->formatStateUsing(function (TextColumn $column): ?string {
                        return ProductType::getProductType($column->getRecord()->productable_type);
                    }),

                TextColumn::make('created_at')->label('Order Date')->dateTime('Y-m-d'),
            ])
            ->actions([]); // Add actions if necessary
    }

    protected function getTableQuery(): Builder
    {
        return Order::query()->where('user_id', $this->user->id);
    }


}
