<?php

namespace App\Enums\Order;

enum OrderStatus: int
{
    case PENDING = 1;
    case PAID = 2;
    case Canceled = 3;


    public static function getOrderStatus(): array
    {
        return [
            self::PENDING->value => 'pending',
            self::PAID->value => 'paid',
            self::Canceled->value => 'canceled',

        ];
    }


    public static function getStatus($status): string
    {
        return match ($status) {
            self::PENDING->value, null => 'pending',
            self::PAID->value => 'paid',
            self::Canceled->value => 'canceled',

        };
    }

}
