<?php

namespace App\Enums\About;

enum AboutUsTypes: int
{
    case VISION = 1;

    case MISSION = 2;
    case OUR_MESSAGE = 3;
    case YOU_TUBE = 4;
    case SLOGAN = 5;

    public static function getAboutUsTypes(): array
    {
        return [
            self::VISION->value => 'Vision',
            self::MISSION->value => 'Mission',
            self::OUR_MESSAGE->value => 'Our message',
            self::YOU_TUBE->value => 'Youtube',
            self::SLOGAN->value => 'Slogan',
        ];
    }

    public static function getAboutUsType($type): string
    {
        return match ($type) {
            self::VISION->value => 'Vision',
            self::MISSION->value => 'Mission',
            self::OUR_MESSAGE->value => 'Our message',
            self::YOU_TUBE->value => 'Youtube',
            self::SLOGAN->value => 'Slogan',
            null => ' ',
        };
    }

}
