<?php

namespace App\DTOs\Api\Profile;

use App\DTOs\AbstractDTO;

class UpdateProfileDto extends AbstractDTO
{
    private ?string $first_name;
    private ?string $last_name;
    private ?string $display_name;
    private ?string $email;

    /**
     * @return array
     */
    final public function toArray(): array
    {
        return [
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'display_name' => $this->display_name,
            'email' => $this->email,
        ];
    }

    /**
     * @return string|null
     */
    public function getFirstName(): ?string
    {
        return $this->first_name;
    }

    /**
     * @return string|null
     */
    public function getLastName(): ?string
    {
        return $this->last_name;
    }

    /**
     * @return string|null
     */
    public function getDisplayName(): ?string
    {
        return $this->display_name;
    }

    /**
     * @return string|null
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    final protected function map(array $data): bool
    {
        $this->first_name = isset($data['first_name']) ? $data['first_name'] : null;
        $this->last_name = isset($data['last_name']) ? $data['last_name'] : null;
        $this->display_name = isset($data['display_name']) ? $data['display_name'] : null;
        $this->email = isset($data['email']) ? $data['email'] : null;
        return true;
    }


}
