<?php

namespace App\DTOs\Api\Profile;

use App\DTOs\AbstractDTO;

class GetProfileDto extends AbstractDTO
{
    private ?string $search;
    /**
     * @return array
     */
    final public function toArray(): array
    {
        return [];
    }

    final protected function map(array $data): bool
    {
        $this->search = isset($data['search']) ? $data['search'] : null;
        return true;
    }

    /**
     * @return string|null
     */
    public function getSearch(): ?string
    {
        return $this->search;
    }



}
